// Rad_Panel.js | Radnen 2008 //
// The panel object is used to contain
// objects known as controls and display them
// along with accompanying images and text.

function Panel(x, y, w, h, style)
{
	if (!this instanceof Panel) return new Panel(x, y, w, h, style);
	this.x = x; this.y = y;
	this.w = w; this.h = h;
	this.xv = x; this.yv = y;
	this.nx = x; this.ny = y;
	this.style = style || new Style();
	this.active = true;
	this.controls = [];
	this.windows = [];
	this.images = [];
	this.texts = [];
	this.rectangles = [];
	this.currentRect = 0;
	this.active = true;
	this.moved = false;
	this.useWindow = true;
	this.onRectangleClick = function(){};
}

Panel.prototype.addControl = function(object_reference)
{
	this.controls.push(object_reference);
}

Panel.prototype.addImage = function(image, x, y)
{
	this.images.push({img:image, x:x, y:y});
}

Panel.prototype.addText = function(x, y, text)
{
	this.texts.push({txt:text, x:x, y:y});
}

Panel.prototype.addWindowStyle = function(x, y, w, h)
{
	this.windows.push({x:x, y:y, w:w, h:h});
}

Panel.prototype.addRectangle = function(x, y, w, h, color)
{
	this.rectangles.push({x:x, y:y, w:w, h:h, color:color});
}

Panel.prototype.blit = function()
{
	if (this.time + this.msecs > GetTime()) this.slide(this.msecs);
	else this.moved = true, this.xv = this.nx, this.yv = this.ny, this.x = this.nx, this.y = this.ny;
	
	if (this.useWindow) this.style.window.drawWindow(this.xv, this.yv, this.w, this.h);
	
	// Draw Windows //
	for (var i = 0; i < this.windows.length; ++i)
	{
		var win = this.windows[i];
		this.style.window.drawWindow(this.xv+win.x, this.yv+win.y, win.w, win.h);
	}
	
	// Draw Rectangles //
	for (var i = 0; i < this.rectangles.length; ++i)
	{
		var rect = this.rectangles[i];
		Rectangle(this.xv+rect.x, this.yv+rect.y, rect.w, rect.h, rect.color);
		if (Cursor.x > this.xv+rect.x && Cursor.y > this.yv+rect.y &&
				Cursor.x < this.xv+rect.x+rect.w && Cursor.y < this.yv+rect.y+rect.h)
		{
			this.currentRect = i;
			if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
			{
				Cursor.leftIdle = false;
				this.onRectangleClick();
			}
		}
	}
	
	// Draw Images //
	for (var i = 0; i < this.images.length; ++i)
	{
		var img = this.images[i];
		img.img.blit(this.xv+img.x, this.yv+img.y);
	}
	
	// Draw Texts //
	for (var i = 0; i < this.texts.length; ++i)
	{
		var txt = this.texts[i];
		this.style.drawText(this.xv+txt.x, this.yv+txt.y, txt.txt);
	}
	
	// Draw Controls //
	for (var i = 0; i < this.controls.length; ++i) this.controls[i].blit();
}

Panel.prototype.handlePanel = function()
{
	while (AreKeysLeft())
	{
		switch(GetKey())
		{
			case KEY_UP: this.handling.KeyUp(); break;
			case KEY_DOWN: this.handling.KeyDown(); break;
			case KEY_LEFT: this.handling.KeyLeft(); break;
			case KEY_RIGHT: this.handling.KeyRight(); break;
			case KEY_SPACE: this.handling.KeySpace(); break;
			case KEY_ENTER: this.handling.KeyEnter(); break;
			case KEY_ESCAPE: this.handling.KeyEscape(); break;
		}
	}
}

Panel.prototype.slideTo = function(x, y, msecs)
{
	this.time = GetTime();
	this.nx = x;
	this.ny = y;
	this.msecs = msecs;
	this.moved = false;
}

Panel.prototype.slideFrom = function(x, y)
{
	this.x = x;
	this.y = y;
	this.nx = x;
	this.ny = y;
}

Panel.prototype.slide = function(msecs)
{
	if (this.nx > this.x) this.xv = this.x + (GetTime() - this.time) * (this.nx-this.x) / msecs;
	if (this.nx < this.x) this.xv = this.x - (GetTime() - this.time) * (this.x-this.nx) / msecs;
	if (this.ny > this.y) this.yv = this.y + (GetTime() - this.time) * (this.ny-this.y) / msecs;
	if (this.ny < this.y) this.yv = this.y - (GetTime() - this.time) * (this.y-this.ny) / msecs;	
}